#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//cherry blossom ribbonMod01.fsh   by   jemappelle 
//https://www.shadertoy.com/view/wdcyzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

uniform float zMotion;
uniform float lowFreqFFT;
uniform float midFreqFFT;
uniform float highFreqFFT;

float opSubtract(float o0, float o1){return max(-o0,o1);}

float opIntersection(float o0, float o1){return max(o0,o1);}

float diffuse_directional(vec3 n, vec3 l){
  	return dot(n, normalize(l))*.5 + .5;
}

float sphere(vec3 d, float r){
  	//d = mod(d, 2.)-2*0.5;  
  	return length(d)-r;
}

float sdRoundedX(in vec2 d, in float w, in float r ){
   	d = abs(d);
   	return length(d-min(d.x+d.y,w)*0.5) - r;
}

float sdHexPrism( vec3 p, vec2 h ){
  	const vec3 k = vec3(-0.8660254, 0.5, 0.57735);
  	p = abs(p);
  	p.xy -= 2.0*min(dot(k.xy, p.xy), .0)*k.xy;
  	vec2 d = vec2(
   	length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),p.z-h.y );
  	return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float hexMap(vec3 d){
    d = mod(d, 2.)-2.*0.5;  
  	return opIntersection(-sdHexPrism(d, vec2(0.6, 1.0)), sdHexPrism(d, vec2(0.61, 1.)));
}

float map(vec3 d){
  	d = mod(d, 2.)-2.*0.5;  
  	return mix(sdRoundedX(d.xy, 0.3, 0.12), (sphere(d, 0.4)), cos(iTime*0.8*0.8));
}

vec3 get_normal(vec3 p){
  	vec2 eps = vec2(0.01,0.);
  	return normalize(vec3(map(p+eps.xyy) - map(p-eps.xyy),
    map(p+eps.yxy) - map(p-eps.yxy),  
    map(p+eps.yyx) - map(p-eps.yyx)));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	// Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
	uv-=0.5;
    uv/=vec2(iResolution.y/iResolution.x, 1);
    // Time varying pixel color
    //vec3 col = 0.5 + 0.5*sin(iTime+uv.xyx+vec3(0,2,4));
 	float circle = smoothstep(0.05*uv.y, 0.5,length(uv.x));
  
  	vec3 ro = vec3(0.+cos(iTime)/2.,zMotion,-8.+(iTime*4.)); 
  	vec3 p = ro;
  	vec3 rd = normalize(vec3(uv,1.));
    //vec3 rd = normalize(vec3(uv,shapeColour));
  
  	bool hit = false;
  	bool hit2 = false;
  	float shading = 0.;
  
  	for(float i = 0.; i < 15.; i++){
    	float env = map(p);
    	float hex = hexMap(p);
    	if(env<0.01){
      		hit = true;
      		shading = i/100.;
      		break;
    	}
    	p += env * sin(rd-ro/50.);
    	//p += env * rd + hex+iTime/100.;
  	}
 
  
  	//Waving screen
  	uv.x += sin(uv.y*8.5)*0.1;
  	uv.y += sin(uv.x*8.5+iTime)*0.5;
  	//Screen split
  	uv.x = mod(uv.x, 0.1)-0.2*0.5;
  
  	//Shape
  	float verLine = smoothstep(0.1, 0.8,length(uv.y-circle));
  
  	//Color define
  	vec3 color = vec3(0.);
  
  
  	//Color from raymarch
  	if(hit){
    	vec3 n = get_normal(p);
    	vec3 l = vec3(0.5,2.,-2.);
    	color = get_normal(p) + vec3(shading);
        
        //Colour as static
        //color = mix(vec3(0.8,0.05,0.2), vec3(0.1,0.0,0.0), vec3(diffuse_directional(n,l)));
        
        //Colour with uniform
        color = mix(vec3(lowFreqFFT,0.,0.), vec3(0.1,0.0,0.0), vec3(diffuse_directional(n,l)));
    	
        hit = false;
  	}else if(hit2){
    	vec3 n = get_normal(p);
    	vec3 l = vec3(0.5,2.,-4.);
    	color = get_normal(p) + vec3(shading);
    	color = mix(vec3(0.65,0.65,0.7), vec3(0.1,0.0,0.0), mix(vec3(0.65,0.45,0.7), vec3(circle-verLine),
    	vec3(diffuse_directional(n,l))));
    	hit2 = false;
  	}else{
    	//color = vec3(circle - verLine/shading);
    	color = vec3(circle -= atan(verLine)*iTime);
  	}
  	float t = length(ro*p);
  	//is final output for now
  	vec3 fog = mix(color, vec3(0.1,0.1,0.2), 1.*exp(-0.01*t*t));
    
  	fragColor = vec4(fog, 0.1) + vec4((color + circle / 1.5), 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

